function [csv_exp] = sav2csv(data,filename,pathname)
%This little ditty allows you to have a quick way of saving a dataset to a
%csv file.
%Synatax:   [data] = sav2csv(data); 
%Input:     data = The data set to be saved
%           Note: if no filename and pathname are entered the function will
%               prompt for input. 
%           filename = the filename to use
%           pathname = the path to save it in
%Output:    The data set to be saved now a dataset object

if nargin~=3    %no explicit directory
    [filename,pathname,filterindex] = uiputfile2('.csv');       %get the directory and the filenames
end
%remove the file type if needed
if strcmp('.',filename(1,end-3)) || strcmp('.',filename(1,end-4))  %note this recognizes '.tiff', but leaves the '.'
    filename = filename(1:end-4);   %remove the file type first
end

%Now save the data to CSV files.
if ~isa(data,'dataset')     %make sure the data is not already a dataset
    data = dataset(data);               %to export as a CSV need to make the data a dataset.
end
%export(csv_exp,'XLSfile',[[pathname,'csv',slash],[filenames(1:end-4),'.xls']]);
export(data,'File',[[pathname,filesep],[filename,'.csv']],'delimiter',',')


